/******************************************************************************
 * %Id: iosc-internal-dev.h 170 2010-02-25 02:46:48Z 4011017 $
 *
 * FileName		:iosc-internal-dev.h
 *
 * Description	:Inner header file for iosc-internal.c
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef IOSC_INTERNAL_DEV_H
#define IOSC_INTERNAL_DEV_H

#if defined(CONFIG_SMP)
#define __SMP__
#endif

#if defined(CONFIG_MODVERSIONS)
#define MODVERSIONS
#endif

#include <linux/autoconf.h>
#ifdef MODULE
#include <linux/module.h> /* Definitions needed for kernel modules */
#endif
#include <linux/kernel.h> /* We run in the kernel so we need this */
#include <linux/proc_fs.h> /* The /proc definitions are in this one */
#include <linux/types.h>
#include <linux/init.h>
#include <linux/rwsem.h>
#include <linux/rwsem-spinlock.h>
#include <linux/poll.h>
#include <linux/mm.h>

#include "dev-share.h"

#define IOSC_VERSION "0.3 (" __DATE__ " - " __TIME__ ")"

/* definition */
#define IOSC_PROC_NAME_FORMAT    "iosc-%s"
#define IOSC_MAX_BLOCK              16
#define MAX_PROC_NAME       16


/* access statistics information */
struct iosc_stat_t {
  int open_count;               /* open count */
  int release_count;            /* release(close) count */
  int read_count;               /* read count */
  int read_byte;                /* read size */
  int write_count;              /* write count */
  int write_byte;               /* write size */
  int ioctl_count;              /* ioctl count */
  int poll_count;               /* poll count */
  int mmap_count;               /* mmap count */
};


#define DEVICE_NR	256

/* structure of device communication port */
struct iosc_port_t {
//    int os;
    int major;                           /* major number */
    int minor;                           /* minor number */
    int type;                            /* acceptable command type */
    int lock_flag;                       /* lock flag for device file (open) */
    int open_flag;                       /* oprn flag of device */
    unsigned long mmap_base;             /* base address for mmap offset */
    wait_queue_head_t open_wait;         /* wait queue of packet */
    struct iosc_packet_queue_t request;  /* request(send) queue */
    struct iosc_packet_queue_t reply;    /* reply(response) queue */
    struct iosc_packet_queue_t fifo;     /* FIFO queue */
    pid_t pid;                           /* process pid of open device */
    char *comm;                          /* command line of open device */
    struct iosc_data_block_t block[IOSC_MAX_BLOCK];
//    struct iosc_port_t *buddy;           /* port of communication partner */
    struct iosc_stat_t stat;             /* access statistics information of device */
    struct mutex mutex;                  /* mutex for command communication */
};

#if 0
/* OS management structure */
struct iosc_os_t {
    int major;
    int type;
    char *name;
    struct iosc_port_t *port;
};
#endif

/* device management structure */
struct iosc_dev_t {
    char *module_name;                  /* regist name of module */
    int n_minor;

	int major;
	int type;
	char *name;
	struct iosc_port_t *port;

    unsigned long mmap_base;
//    struct iosc_os_t os[IOSC_MAX_OS];   /* OS management structure(0:RTOS 1:Linux) */
    char proc_name[MAX_PROC_NAME];      /* pass name of proc entry (except /proc) */
    struct proc_dir_entry *proc_entry;  /* entity of proc entry */
};

#endif /* IOSC_INTERNAL_DEV_H */
